﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class RegistrantHistoryManager
    {

        string connectionInfo = string.Empty;

        public RegistrantHistoryManager() { }
        public RegistrantHistoryManager(string dbConnectionInfo)
        {
            connectionInfo = dbConnectionInfo;
        }
        public  RegistrantHistory CreateRegistrantHistory(string edipi)
        {
            var history = new RegistrantHistory();
            history.BranchesOfService = new BranchesOfServiceManager().GetRegistrantsBranchesOfService(edipi);
            history.OccupationsByDateTime = new MilitaryOccupationHistoryManager(connectionInfo).GetRegistrantHistory(edipi);
            history.PersonnelCategoryCodesByDateRange = GetPersonnelCategoryCodes(edipi);
            history.PaymentDataByDateTime = new PaymentHistoryManager().GetRegistrantHistory(edipi);
            return history;
        }

        private Dictionary<DateRange, string> GetPersonnelCategoryCodes(string edipi)
        {
            var mse = new MilitaryServiceEpisodeManager(connectionInfo);
            return mse.GetPersonnelCategoryCodes(edipi);
        }
    }
}
